function GetScreenContinueNextScreen()
	if GAMESTATE:GetNumPlayersEnabled() == 0 then
		return SelectEndingScreen();
	end

	if STATSMAN:GetStagesPlayed() == 0 then
		return "ScreenSelectStyle";
	end

	return "ScreenProfileLoad";
end

function ScreenProfileSaveNextScreen()
	if IsEventMode() then
		return SongSelectionScreen();
	end
	return SelectEndingScreen();
end

function IsEventMode()
	return PREFSMAN:GetPreference( "EventMode" );
end

function GetEvaluationNextScreen()
	if IsEventMode() then
		return "ScreenProfileSave";
	end;

	local sFailedScreen;
	local sEndScreen;
	local pm = GAMESTATE:GetPlayMode();
	if pm == "PlayMode_Regular" or
		pm == "PlayMode_Rave" then
		sFailedScreen = "ScreenProfileSave";
		sEndScreen = "ScreenEvaluationSummary";
	elseif pm == "PlayMode_Nonstop" or
		pm == "PlayMode_Oni" or
		pm == "PlayMode_Endless" then
		sFailedScreen = "ScreenNameEntry";
		sEndScreen = "ScreenNameEntry";
	else
		assert(false);
	end

	local sNextScreen;
	if IsNetSMOnline() then sNextScreen = "ScreenNetRoom"
	elseif( IsNetConnected() ) then sNextScreen = "ScreenNetSelectMusic"
	else sNextScreen = SongSelectionScreen(); end
	
	return GetEvaluationNextScreenInternal( sNextScreen, sFailedScreen, sEndScreen );
end